<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDriversTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('drivers', function (Blueprint $table) {
            $table->id();
            $table->integer('iddoc');
            $table->string('dni_ruc', 15);
            $table->string('nombres');
            $table->string('direccion');
            $table->string('codigo_pais', 2);
            $table->string('ubigeo', 6);
            $table->string('telefono', 100)->nullable();
            $table->string('placa', 100);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('drivers');
    }
}
