<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Reporte de Ventas General</title>
    <style>
        #cabecera {
            text-align: center;
            text-decoration: underline;
        }

        body {
            font-family: sans-serif;
        }

        .th_informacion {
            text-align: left;
            width: 200px;
        }

        .td_informacion {
            text-align: left;
        }

        .th_items,
        .td_items {
            text-align: center;
        }

        #table_items {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        #thead_items {
            width: 100%;
        }

        .border-solid {
            border: 1px solid #dee2e6
        }

        .text-right {
            text-align: right;
        }

        .text-danger {
            color: rgb(234, 84, 85);
        }

        .pay_mode {
            margin-bottom: 0px; 
            margin-top: 0px; 
            text-align: center;
        }

        .tachado {
        text-decoration:line-through;
        }
    </style>
</head>

<body>
    <div id="cabecera">
        <h4>REPORTE DE VENTAS GENERAL</h4>
    </div>

    <div id="informacion">
        <table style="font-size: 15px;">
            <tr>
                <th class="th_informacion">RUC</th>
                <td class="td_informacion"><?php echo e($business->ruc); ?></td>
            </tr>

            <tr>
                <th class="th_informacion">EMPRESA</th>
                <td class="td_informacion"><?php echo e($business->nombre_comercial); ?></td>
            </tr>

            <tr>
                <th class="th_informacion">FECHAS</th>
                <td class="td_informacion"><?php echo e(date('d-m-Y', strtotime($fecha_inicial))); ?> a <?php echo e(date('d-m-Y', strtotime($fecha_final))); ?></td>
            </tr>
        </table>
    </div>

    <div id="items">
        <table id="table_items">
            <thead id="thead_items" style="font-size: 12px;">
                <tr>
                    <th colspan="3" class="th_items border-solid" style="text-align: center; border: 1px solid #151515">Documento</th>
                    <th colspan="2" class="th_items border-solid" style="text-align: center; border: 1px solid #151515">Cliente</th>
                    <th colspan="5" class="th_items border-solid" style="text-align: center; border: 1px solid #151515">Soles</th>
                </tr>
                <tr>
                    <th class="th_items border-solid" style="text-align: center; border: 1px solid #151515">Fecha</th>
                    <th class="th_items border-solid" style="text-align: center; border: 1px solid #151515">Documento</th>
                    <th class="th_items border-solid" style="text-align: center; border: 1px solid #151515">Pago</th>
                    <th class="th_items border-solid" style="text-align: center; border: 1px solid #151515">RUC / DNI</th>
                    <th class="th_items border-solid" style="border: 1px solid #151515">Razón Social</th>
                    <th class="th_items border-solid" style="text-align: center; border: 1px solid #151515">Exonerada</th>
                    <th class="th_items border-solid" style="text-align: center; border: 1px solid #151515">Gravada</th>
                    <th class="th_items border-solid" style="text-align: center; border: 1px solid #151515">Inafecta</th>
                    <th class="th_items border-solid" style="text-align: center; border: 1px solid #151515">IGV</th>
                    <th class="th_items border-solid" style="text-align: center; border: 1px solid #151515">Importe</th>
                </tr>
            </thead>

            <tbody>
                <?php $__currentLoopData = $billings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr style="font-size: 12px;" class="<?php echo e($item["estado_venta"] == 2 ? 'tachado' : ''); ?>">
                        <td class="td_items border-solid" style="text-align: center; border: 1px solid #151515"><?php echo e(date('d-m-Y', strtotime($item["fecha_emision"]))); ?></td>
                        <td class="td_items border-solid" style="text-align: center; border: 1px solid #151515"><?php echo e($item["serie"] ."-". $item["correlativo"]); ?></td>
                        <td class="td_items border-solid" style="text-align: center; border: 1px solid #151515">
                            <?php $__currentLoopData = $pagos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $__currentLoopData = $pago; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($item_pago->idfactura == $item["id"] && $item["idtipo_comprobante"] == $item_pago->idtipo_comprobante): ?>
                                    <p class="pay_mode"><?php echo e($item_pago->tipo_pago); ?>: <?php echo e($item_pago->monto); ?></p>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="td_items border-solid" style="text-align: center; border: 1px solid #151515"><?php echo e($item["dni_ruc"]); ?></td>
                        <td class="text-left border-solid" style="border: 1px solid #151515"><?php echo e($item["nombre_cliente"]); ?></td>
                        <td class="td_items border-solid" style="text-align: center; border: 1px solid #151515"><?php echo e($item["exonerada"]); ?></td>
                        <td class="td_items border-solid" style="text-align: center; border: 1px solid #151515"><?php echo e($item["gravada"]); ?></td>
                        <td class="td_items border-solid" style="text-align: center; border: 1px solid #151515"><?php echo e($item["inafecta"]); ?></td>
                        <td class="td_items border-solid" style="text-align: center; border: 1px solid #151515"><?php echo e($item["igv"]); ?></td>
                        <td class="td_items border-solid" style="text-align: center; border: 1px solid #151515"><?php echo e($item["total"]); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td colspan="9" class="text-right border-solid" style="text-align: right; border: 1px solid #151515">Total S/ &nbsp;</td>
                    <td class="td_items border-solid" style="text-align: center; border: 1px solid #151515"><?php echo e(number_format($total, 2, '.', '')); ?></td>
                </tr>
                <tr>
                    <td colspan="9" class="text-right border-solid text-danger" style="text-align: right; border: 1px solid #151515">Anulado S/ &nbsp;</td>
                    <td class="td_items border-solid text-danger" style="text-align: center; border: 1px solid #151515"><?php echo e(number_format($anulado, 2, '.', '')); ?></td>
                </tr>
                <tr>
                    <td colspan="9" class="text-right border-solid" style="text-align: right; border: 1px solid #151515">Total Neto S/ &nbsp;</td>
                    <td class="td_items border-solid" style="text-align: center; border: 1px solid #151515"><?php echo e(number_format($total_neto, 2, '.', '')); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
</body>

</html><?php /**PATH C:\xampp\htdocs\mytems2.0\sales\resources\views/admin/reports/sales/general/excel.blade.php ENDPATH**/ ?>