<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <style>
        html {
            margin: 0px;
            font-family: 'sans-serif';
        }

        .cabecera {
            text-align: center;
        }

        .informacion {
            text-align: left;
            margin-left: 15px;
            margin-right: 15px;
        }

        .payments
        {
            text-align: right;
            margin-left: 15px;
            margin-right: 15px;
        }

        .informacion_caja {
            text-align: right;
            margin-left: 15px;
            margin-right: 15px;
        }

        .tabla_detalle {
            margin-left: 15px;
            margin-right: 15px;
            margin-top: 5px;
        }

        .text-center {
            text-align: center;
        }

        .informacion_representacion {
            text-align: center;
        }

        footer {
            position: fixed; 
                bottom: 0cm; 
                left: 0cm; 
                right: 0cm;
                height: 2cm;

                /** Estilos extra personales **/
                background-color: white;
                color: black;
                text-align: center;
                line-height: 1.5cm;
            }
    </style>
</head>

<body>
    <div class="cabecera">
        <p style="font-size: 15px; font-weight: bold; margin-bottom: 0; margin-top: 10px;"><?php echo e($business->nombre_comercial); ?></p>
        <p style="font-size: 9.5px; margin-top:0; margin-bottom: 0;"><?php echo e($business->direccion); ?></p>
        <p style="font-size: 9.5px; margin-top:0; margin-bottom: 0;"><?php echo e($ubigeo["distrito"]); ?> - <?php echo e($ubigeo["departamento"]); ?></p>
        <p style="font-size: 13.5px; font-weight: bold; margin-top:0; margin-bottom: 0;">RUC: <?php echo e($business->ruc); ?></p>
        <p style="font-size: 13.5px; font-weight: bold; margin-top:0; margin-bottom: 0;">
            <?php echo e($tipo_comprobante->descripcion); ?>

        </p>
        <p style="font-size: 13.5px; font-weight: bold; margin-top:0; margin-bottom: 0;">
            <?php echo e($reference_guide->serie); ?>-<?php echo e($reference_guide->correlativo); ?>

        </p>

        <div class="informacion">
            <p style="font-size: 10px; margin-top:10px; margin-bottom: 0;">C&Oacute;DIGO: <b><?php echo e($reference_guide->codigo); ?></b></p>
            <p style="font-size: 9.5px; margin-top:0px; margin-bottom: 0;">Fecha de Emisión: <?php echo e(date('d/m/Y', strtotime($reference_guide->fecha_emision))); ?> Hora: <?php echo e($reference_guide->hora); ?></p>
        </div>
    </div>

    <div class="text-center" style="margin-top: 0px; margin-bottom: 0px;">
        <img src="<?php echo e(public_path('files/qrs/' . $reference_guide->qr)); ?>" alt="NULO" style="width: 100px; height: 100px;">
    </div>

    <div class="informacion">
        <p style="font-size: 9px; margin-top:10px; margin-bottom: 0;"><b>Origen:</b> <?php echo e($reference_guide->origen_direccion); ?> <?php echo e($reference_guide->origen_provincia); ?></p>
        <p style="font-size: 9px; margin-top:0; margin-bottom: 0;"><b>Destino:</b> <?php echo e($reference_guide->destino_direccion); ?> <?php echo e($reference_guide->destino_provincia); ?></p>
    </div>

    <div class="informacion">
        <p style="font-size: 10px; margin-top:9px; font-weight: bold; margin-bottom: 0;">DATOS DEL REMITENTE</p>
        <p style="font-size: 9px; margin-top:0; margin-bottom: 0;"><b>Nombre/Raz. Social:</b> <?php echo e($remitente->nombres); ?></p>
        <p style="font-size: 9px; margin-top:0; margin-bottom: 0;"><b>DNI/RUC:</b> <?php echo e($remitente->dni_ruc); ?> - <b>Tel&eacute;fono:</b> <?php echo e($remitente->telefono); ?></p>
    </div>

    <div class="informacion">
        <p style="font-size: 10px; margin-top:9px; font-weight: bold; margin-bottom: 0;">DATOS DEL DESTINATARIO</p>
        <p style="font-size: 9px; margin-top:0; margin-bottom: 0;"><b>Nombre/Raz. Social:</b> <?php echo e($destinatario->nombres); ?></p>
        <p style="font-size: 9px; margin-top:0; margin-bottom: 0;"><b>DNI/RUC:</b> <?php echo e($destinatario->dni_ruc); ?> - <b>Tel&eacute;fono:</b> <?php echo e($destinatario->telefono); ?></p>
    </div>

    <div class="informacion">
        <p style="font-size: 9px; margin-top:9px; font-weight: bold; margin-bottom: 0;"><b>FORMA DE PAGO: <?php echo e($reference_guide->modo_pago_guia); ?></b></p>
    </div>

    <div class="tabla_detalle">
        <table style="border-top: 1px solid #c2c2c2;" width="100%">
            <thead style="border-bottom: 1px solid #c2c2c2" style="width: 100%">
                <tr>
                    <th style="font-size: 12px;">Cant.</th>
                    <th style="font-size: 12px; text-align: left;">Descripción</th>
                    <th style="font-size: 12px;">P/U</th>
                    <th style="font-size: 12px; text-align:right;">Total</th>
                </tr>
            </thead>

            <tbody style="border-bottom: 1px solid #c2c2c2">
                <?php $__currentLoopData = $detalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr style="border-bottom: 1px solid #c2c2c2">
                    <td style="font-size: 10px; text-align:center; vertical-align: top">[ <?php echo e(round($product['cantidad'])); ?> ]</td>
                    <td style="font-size: 10px; text-align:left; vertical-align: top"><?php echo e($product['producto']); ?></td>
                    <td style="font-size: 10px; text-align:center; vertical-align: top"><?php echo e($product['precio_unitario']); ?></td>
                    <td style="font-size: 10px; text-align:right; vertical-align: top;"><?php echo e($product['precio_total']); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

            <tbody style="border-bottom: 1px solid #c2c2c2">
                <tr>
                    <td style="font-size: 11px; font-weight: bold; text-align: right;" colspan="2">OP. Gravadas:</td>
                    <td style="font-size: 11px; font-weight: bold; text-align: right;" colspan="2">S/ <?php echo e(number_format(($reference_guide->exonerada + $reference_guide->gravada + $reference_guide->inafecta), 2, ".", "")); ?></td>
                </tr>

                <tr>
                    <td style="font-size: 11px; font-weight: bold; text-align: right;" colspan="2">IGV:</td>
                    <td style="font-size: 11px; font-weight: bold; text-align: right;" colspan="2">S/ <?php echo e($reference_guide->igv); ?></td>
                </tr>
            </tbody>

            <tbody style="border-top: 1px solid #c2c2c2; margin-bottom: 20px;">
                <tr>
                    <td style="font-size: 11px; font-weight: bold; text-align: right;" colspan="2">Importe Total:
                    </td>
                    <td style="font-size: 11px; font-weight: bold; text-align: right;" colspan="2">S/ <?php echo e($reference_guide->total); ?></td>
                </tr>
            </tbody>

            <tbody style="border-top: 1px solid #c2c2c2;">
                <tr style="">
                    <td style="font-size: 11px; font-weight: bold; text-align: center;" colspan="4">
                        Son: <?php echo e($numero_letras); ?> Con 00/100 Soles
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    
</body>
</html><?php /**PATH C:\xampp\htdocs\courier\resources\views/admin/reference_guides/create/ticket.blade.php ENDPATH**/ ?>