<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Reporte de Proveedores</title>
    <style>
        #cabecera {
            text-align: center;
            text-decoration: underline;
        }

        body {
            font-family: sans-serif;
        }

        .th_informacion {
            text-align: left;
            width: 220px;
        }

        .td_informacion {
            text-align: left;
        }

        .th_items,
        .td_items {
            text-align: center;
        }

        #table_items {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        #thead_items {
            width: 100%;
        }

        .border-solid {
            border: 1px solid #dee2e6
        }

        .text-right {
            text-align: right;
        }

        .text-danger {
            color: rgb(234, 84, 85);
        }

        .pay_mode {
            margin-bottom: 0px;
            margin-top: 0px;
            text-align: center;
        }
    </style>
</head>

<body>
    <div id="cabecera">
        <h4>REPORTE DE PROVEEDORES</h4>
    </div>

    <div id="informacion">
        <table style="font-size: 15px;">
            <tr>
                <th class="th_informacion">RUC</th>
                <td class="td_informacion">: <?php echo e($business->ruc); ?></td>
            </tr>

            <tr>
                <th class="th_informacion">EMPRESA</th>
                <td class="td_informacion">: <?php echo e($business->nombre_comercial); ?></td>
            </tr>

            <tr>
                <th class="th_informacion">CANTIDAD DE PROVEEDORES</th>
                <td class="td_informacion">: <?php echo e($quantity); ?></td>
            </tr>
        </table>
    </div>

    <div id="items">
        <table id="table_items">
            <thead id="thead_items" style="font-size: 12px;">
                <tr>
                    <th class="th_items border-solid">Tipo Doc.</th>
                    <th class="th_items border-solid">N&uacute;mero</th>
                    <th class="td_informacion border-solid">Nombres</th>
                    <th class="th_items border-solid">Correo Electr&oacute;nico</th>
                    <th class="th_items border-solid">Direcci&oacute;n</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $providers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr style="font-size: 12px;">
                        
                        <td class="td_items border-solid"><?php echo e($item->documento); ?></td>
                        <td class="td_items border-solid"><?php echo e($item->dni_ruc); ?></td>
                        <td class="td_informacion border-solid"><?php echo e($item->nombres); ?></td>
                        <?php if($item->correo == null): ?>
                        <td class="td_items border-solid">-</td>
                        <?php else: ?>
                        <td class="td_items border-solid"><?php echo e($item->correo); ?></td>
                        <?php endif; ?>
                        <td class="td_items border-solid"><?php echo e($item->direccion); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr style="font-size: 12px;">
                        <td class="td_informacion border-solid" colspan="5"></td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\mytems2.0\sales\resources\views/admin/reports/contacts/providers/excel.blade.php ENDPATH**/ ?>