
<?php $__env->startSection('content'); ?>
<div class="row">
    <!-- View sales -->
    <div class="col-xl-4 mb-4 col-lg-5 col-12">
      <div class="card">
        <div class="d-flex align-items-end row">
          <div class="col-7">
            <div class="card-body text-nowrap">
              <h5 class="card-title mb-0">Felicidades <?php echo e($seller_name); ?></h5>
              <p class="mb-2">Mejor vendedor del mes</p>
              <h4 class="text-primary mb-1">S/<?php echo e(number_format($seller_total, 2, ".", "")); ?></h4>
              <a href="<?php echo e(route('admin.sales_seller')); ?>" class="btn btn-primary">Ver Resumen</a>
            </div>
          </div>
          <div class="col-5 text-center text-sm-left">
            <div class="card-body pb-0 px-0 px-md-4">
              <img
                src="<?php echo e(asset('assets/img/illustrations/card-advance-sale.png')); ?>"
                height="130"
                alt="view sales" />
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- View sales -->

    <!-- Statistics -->
    <div class="col-xl-8 mb-4 col-lg-7 col-12">
      <div class="card h-100">
        <div class="card-header">
          <div class="d-flex justify-content-between mb-3">
            <h5 class="card-title mb-0">Estad&iacute;sticas</h5>
            <small class="text-muted">Actualizaci&oacute;n constante</small>
          </div>
        </div>
        <div class="card-body">
          <div class="row gy-3">
            <div class="col-md-3 col-6">
              <div class="d-flex align-items-center">
                <div class="badge rounded-pill bg-label-primary me-3 p-2">
                  <i class="ti ti-chart-pie-2 ti-sm"></i>
                </div>
                <div class="card-info">
                  <h5 class="mb-0"><?php echo e(count($billings) + count($sale_notes)); ?></h5>
                  <small>Ventas</small>
                </div>
              </div>
            </div>
            <div class="col-md-3 col-6">
              <div class="d-flex align-items-center">
                <div class="badge rounded-pill bg-label-info me-3 p-2">
                  <i class="ti ti-users ti-sm"></i>
                </div>
                <div class="card-info">
                  <h5 class="mb-0"><?php echo e(count($clients)); ?></h5>
                  <small>Clientes</small>
                </div>
              </div>
            </div>
            <div class="col-md-3 col-6">
              <div class="d-flex align-items-center">
                <div class="badge rounded-pill bg-label-danger me-3 p-2">
                  <i class="ti ti-shopping-cart ti-sm"></i>
                </div>
                <div class="card-info">
                  <h5 class="mb-0"><?php echo e(count($products)); ?></h5>
                  <small>Productos</small>
                </div>
              </div>
            </div>
            <div class="col-md-3 col-6">
              <div class="d-flex align-items-center">
                <div class="badge rounded-pill bg-label-success me-3 p-2">
                  <i class="ti ti-currency-dollar ti-sm"></i>
                </div>
                <div class="card-info">
                  <h5 class="mb-0">S/<?php echo e(number_format($sum_billings + $sum_sale_notes, 2, ".", "")); ?></h5>
                  <small>Ganancias</small>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!--/ Statistics -->

    <div class="col-xl-4 col-12">
      <div class="row">
        <!-- Expenses -->
        <div class="col-xl-6 mb-4 col-md-3 col-6">
          <div class="card">
            <div class="card-header pb-0">
              <h5 class="card-title mb-0">S/<?php echo e(number_format($bills, 2, ".", "")); ?></h5>
              <small class="text-muted">Gastos</small>
            </div>
            <div class="card-body">
              <div id="expensesChart"></div>
              <div class="mt-md-2 text-center mt-lg-3 mt-3">
                <small class="text-muted mt-3">S/<?php echo e(number_format($bills_former, 2, ".", "")); ?> Gastos m&aacute;s que el mes pasado.</small>
              </div>
            </div>
          </div>
        </div>
        <!--/ Expenses -->

        <!-- Profit last month -->
        <div class="col-xl-6 mb-4 col-md-3 col-6">
          <div class="card">
            <div class="card-header pb-0">
              <h5 class="card-title mb-0">Ganancia</h5>
              <small class="text-muted">&Uacute;ltimo mes</small>
            </div>
            <div class="card-body">
              <div id="profitLastMonth"></div>
              <div class="d-flex justify-content-between align-items-center mt-3 gap-3">
                <h4 class="mb-0"><?php echo e(number_format(($billing_profit + $sale_note_profit), 2, ".", "")); ?></h4>
              </div>
            </div>
          </div>
        </div>
        <!--/ Profit last month -->

        <!-- Generated Leads -->
        <div class="col-xl-12 mb-4 col-md-6">
          <div class="card">
            <div class="card-body">
              <div class="d-flex justify-content-between">
                <div class="d-flex flex-column">
                  <div class="card-title mb-auto">
                    <h5 class="mb-1 text-nowrap">Clientes Potenciales</h5>
                    <small>Reporte Mensual</small>
                  </div>
                  <div class="chart-statistics">
                    <h3 class="card-title mb-1"><?php echo e(count($clients)); ?></h3>
                  </div>
                </div>
                <div id="generatedLeadsChart"></div>
              </div>
            </div>
          </div>
        </div>
        <!--/ Generated Leads -->
      </div>
    </div>

    <!-- Revenue Report -->
    <div class="col-12 col-xl-8 mb-4 col-lg-7">
      <div class="card">
        <div class="card-header pb-3">
          <h5 class="m-0 me-2 card-title">Informe de Ingresos</h5>
        </div>
        <div class="card-body">
          <div class="row row-bordered g-0">
            <div class="col-md-8">
              <div id="totalRevenueChart"></div>
            </div>
            <div class="col-md-4">
              <div class="text-center mt-4">
                <div class="dropdown">
                  <button
                    class="btn btn-sm btn-outline-primary dropdown-toggle"
                    type="button"
                    id="budgetId"
                    data-bs-toggle="dropdown"
                    aria-haspopup="true"
                    aria-expanded="false">
                    <script>
                      document.write(new Date().getFullYear());
                    </script>
                  </button>
                </div>
              </div>
              <h3 class="text-center pt-4 mb-0">S/<?php echo e(number_format($ganancias, 2, ".", "")); ?></h3>
              <div class="px-3">
                <div id="budgetChart"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!--/ Revenue Report -->
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <?php echo $__env->make('admin.js-home-dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\mytems2.0\sales\resources\views/admin/home.blade.php ENDPATH**/ ?>